-- WEAPONS MENU v1.2
-- http://payday.wikia.com/wiki/Weapon_Stats

-- OPEN MENU
function openmenu(menu)
	menu:show()
end

---------------
-- MAIN --
---------------
if not inGame() then
	
	-- UNLOCK ITEMS FUNCTION
	--[[ 
		unlockitems( itype )
		Unlocks items from the given type
	]]--
	function unlockitems( itype )
		local types = {"weapon_mods", "masks", "materials", "textures", "colors", "weapons"}
		if type(itype) == "table" then types = itype end
			if itype == "all" or type(itype) == "table" then
				--for i = 1, #types do unlockitems(types[i]) end
				for i = 1, #types do 
					unlockitems({ ["type"] = types[i] }) 
				end
				return
			elseif not in_table(types, itype) then 
				return 
			end
		if itype == "weapons" then
			for wep_id,_ in pairs(tweak_data.upgrades.definitions) do
				if _.category == "weapon" and not string.find(wep_id, "_primary") and not string.find(wep_id, "_secondary") then
					if not managers.upgrades:aquired(wep_id) then 
						managers.upgrades:aquire(wep_id) 
					end
				end
			end
		else
			for mat_id,_ in pairs(tweak_data.blackmarket[itype]) do
				if _.unlocked == false then 
				_.unlocked = true 
				end
			end
		end
	end
	-- GIVEITEMS FUNCTION
	--[[
		giveitems( itype, times )
		Gives all items for the corresponding item type for the specified number of times. 
		Default is 1 items per use.
		Usage:
		This gives you 5 of every item
		giveitems("all")
		You can specify the type, for example this gives you 5 of every mask
		giveitems("masks")
		You can also pass along a table of only certain item types you want
		giveitems({"masks","textures","colors"})
	]]--
	function giveitems( argumentTable )
		local itype = argumentTable["type"]
		local times = argumentTable["times"]
		
		local types = {"weapon_mods", "masks", "materials", "textures", "colors"}
		local skip = { masks = {"character_locked"}, materials = {"plastic"}, colors = {"nothing"}, textures = {"no_color_full_material","no_color_no_material"} }
		if not times then times = 1 end
			if type(itype) == "table" then types = itype end
			if itype == "all" or type(itype) == "table" then
			for i = 1, #types do giveitems({ ["type"] = types[i], ["times"] = times }) end
			return
		elseif not in_table(types, itype) then return end
		for i=1, times do
			for mat_id,_ in pairs(tweak_data.blackmarket[itype]) do
				if not in_table(skip[itype], mat_id) then
					local global_value = "normal"
					if _.global_value then
					global_value = _.global_value
					elseif _.infamous then
						global_value = "infamous"
					elseif _.dlcs or _.dlc then
					local dlcs = _.dlcs or {}
					if _.dlc then table.insert( dlcs, _.dlc ) end
						global_value = dlcs[ math.random( #dlcs ) ]
					end
					if _.unlocked == false then _.unlocked = true end
				managers.blackmarket:add_to_inventory(global_value, itype, mat_id, false)
				end
			end
		end
	end
	
	-- UNLOCK PRIMARY WEAPON SLOTS 
	unlockprimslots = unlockprimslots or function()
		for i = 1, 36 do
			Global.blackmarket_manager.unlocked_weapon_slots.primaries[i] = true
		end
	end
	-- UNLOCK SECONDARY WEAPON SLOTS 
	unlocksecslots = unlocksecslots or function()
		for i = 1, 36 do
			Global.blackmarket_manager.unlocked_weapon_slots.secondaries[i] = true
		end
	end
	-- UNLOCK ALL WEAPON SLOTS 
	unlockweaponslots = unlockweaponslots or function()
		for i = 1, 36 do
			Global.blackmarket_manager.unlocked_weapon_slots.primaries[i] = true
			Global.blackmarket_manager.unlocked_weapon_slots.secondaries[i] = true
		end
	end
end

---------------
-- GAME --
---------------
if inGame() then
	--------------------------
	-- NORMALIZER --
	--------------------------
	if not _oldRayCastRecoil then _oldRayCastRecoil = NewRaycastWeaponBase.recoil_multiplier
	end
	if not _oldRayCastSpread then _oldRayCastSpread = NewRaycastWeaponBase._get_spread
	end
	if not _oldRayCastReload then _oldRayCastReload = NewRaycastWeaponBase.reload_speed_multiplier
	end
	if not _oldRayCastReload then _oldRayCastReload = NewRaycastWeaponBase.reload_speed_multiplier
	end
	if not _oldRayCastFrate then _oldRayCastFrate = NewRaycastWeaponBase.fire_rate_multiplier
	end
	if not _oldRayCastSwap then _oldRayCastSwap = PlayerStandard._get_swap_speed_multiplier
	end
	if not _uvArmorPierce then _uvArmorPierce = PlayerManager.upgrade_value 
	end 
	if not _oldSentryGod then _oldSentryGod = SentryGunDamage.damage_bullet
	end
	if not _unlSentryAmmo then _unlSentryAmmo = SentryGunWeapon.fire
	end
	if not _onReload then _onReload = RaycastWeaponBase.on_reload
	end
	if not _fireSaw then _fireSaw = SawWeaponBase.fire 
	end
	if not CopDamage.damage_bullet2 then CopDamage.damage_bullet2 = CopDamage.damage_bullet 
	end
	-- WEAPON RECOIL(normalizable)
	recoiloff = recoiloff or function()
		NewRaycastWeaponBase.recoil_multiplier = function(self) return 0
		end
	end
	-- WEAPON SPREAD (normalizable)
	spreadoff = spreadoff or function()
		NewRaycastWeaponBase._get_spread = function(self) return 0
		end
	end
	-- WEAPON RELOAD SPEED PLEASANT(normalizable)
	freload = freload or function()
		NewRaycastWeaponBase.reload_speed_multiplier = function(self) return 2.5
		end
	end
	-- WEAPON RELOAD SPEED INSTANT (normalizable)
	freload2 = freload2 or function()
		NewRaycastWeaponBase.reload_speed_multiplier = function(self) return 1000
		end
	end
	-- WEAPON FIRE RATE (normalizable)
	firerate1 = firerate1 or function()
		NewRaycastWeaponBase.fire_rate_multiplier = function(self) return 3
		end
	end
	-- WEAPON FIRE RATE 2 (normalizable)
	firerate2 = firerate2 or function()
		NewRaycastWeaponBase.fire_rate_multiplier = function(self) return 100
		end
	end
	-- WEAPON SWAP SPEED (normalizable)
	swapspeed = swapspeed or function()
		PlayerStandard._get_swap_speed_multiplier = function(self) return 3
		end
	end
	-- WEAPON SWAP SPEED 2 (normalizable)
	swapspeed2 = swapspeed2 or function()
		PlayerStandard._get_swap_speed_multiplier = function(self) return 25
		end
	end
	-- 100% ARMOR PIERCING (normalizable)
	piercing = piercing or function()
		function PlayerManager:upgrade_value( category, upgrade, default ) 
			if category == "weapon" and upgrade == "armor_piercing_chance" then
				return 1
			elseif category == "weapon" and upgrade == "armor_piercing_chance_silencer" then
				return 1
			else
				return _uvArmorPierce(self, category, upgrade, default) 
			end
		end
	end
	-- INFINITE AMMO ((RESETS AMMO ON RELOAD & ALSO WHEN AMMO RUNS OUT, JUST IN CASE YOU ACTIVATE IT LATE) NORMALIZABLE)
	infammo = infammo or function()
		function RaycastWeaponBase:on_reload()
			if managers.player:player_unit() == self._setup.user_unit then
				self.set_ammo(self, 1.0)
			else
				_onReload(self)
			end
		end
	end
	-- INFINITE SAW AMMO (normalizable)
	infsawammo = infsawammo or function()
		function SawWeaponBase:fire( from_pos, direction, dmg_mul, shoot_player, spread_mul, autohit_mul, suppr_mul, target_unit )
			_fireSaw( self, from_pos, direction, dmg_mul, shoot_player, spread_mul, autohit_mul, suppr_mul, target_unit )
			if managers.player:player_unit() == self._setup.user_unit then
				self.set_ammo(self, 1.0)
			end
		end
	end
	-- SENTRY GUN INDESTRUCTIBLE (normalizable)
	godsentry = godsentry or function()
		function SentryGunDamage:damage_bullet( attack_data ) 
		end
	end
	-- INFINITE SENTRY AMMO, NO RECOIL (NORMALIZABLE)
	infsentry = infsentry or function()
		function SentryGunWeapon:fire( blanks, expend_ammo )
			local fire_obj = self._effect_align[ self._interleaving_fire ]
			local from_pos = fire_obj:position()
			local direction = fire_obj:rotation():y()
			mvector3.spread( direction, tweak_data.weapon[ self._name_id ].SPREAD * self._spread_mul )
			World:effect_manager():spawn( self._muzzle_effect_table[ self._interleaving_fire ] ) -- , normal = col_ray.normal } )
			if self._use_shell_ejection_effect then
				World:effect_manager():spawn( self._shell_ejection_effect_table ) 
			end
				local ray_res = self:_fire_raycast( from_pos, direction, blanks )
				if self._alert_events and ray_res.rays then
				RaycastWeaponBase._check_alert( self, ray_res.rays, from_pos, direction, self._unit )
				end
			return ray_res
		end
	end
	-- INFINITE AMMO BAG USES (normalizable)
	infammobag = infammobag or function()
		if AmmoBagBase then
			function AmmoBagBase:_take_ammo( unit )
				local inventory = unit:inventory()
				if inventory then
					for _,weapon in pairs( inventory:available_selections() ) do
					local took = weapon.unit:base():add_ammo_from_bag( self._ammo_amount )
					end
				end
			return 0
			end
		end
	end
	
	-- SPAWN TRIPMINE ON SELF
	sptripmine = sptripmines or function()
		local from = managers.player:player_unit():movement():m_head_pos()
		local to = from + managers.player:player_unit():movement():m_head_rot():y() * 200
		local ray = managers.player:player_unit():raycast("ray", from, to, "slot_mask", managers.slot:get_mask("trip_mine_placeables"), "ignore_unit", {})
			
		if ray then
		local pos = ray.position
		local unit2 = managers.player:player_unit()
		local sensor_upgrade = managers.player:has_category_upgrade( "trip_mine", "sensor_toggle" )
			if Network:is_client() then
			managers.network:session():send_to_host( "attach_device", pos, ray.normal, sensor_upgrade )
			else
			local rot = Rotation( ray.normal, math.UP )
			local unit = TripMineBase.spawn( pos, rot, sensor_upgrade )
			unit:base():set_active( true, unit2 )
			end
		end
	end
	-- SPAWN SENTRY ON SELF
	spsentry = spsentrys or function()
		local ammo_multiplier = managers.player:upgrade_value( "sentry_gun", "extra_ammo_multiplier", 1 )
		--ammo_multiplier = 80000 * managers.player:upgrade_value( "sentry_gun", "extra_ammo_multiplier", 1 ) infinite ammo
		local armor_multiplier = managers.player:upgrade_value( "sentry_gun", "armor_multiplier", 1 )
		--armor_multiplier = 80000 * managers.player:upgrade_value( "sentry_gun", "armor_multiplier", 1 ) infinite health
		local damage_multiplier = managers.player:upgrade_value( "sentry_gun", "damage_multiplier", 1 )
		local unit = managers.player:player_unit()
		local from = managers.player:player_unit():movement():m_head_pos()
		local to = from + managers.player:player_unit():movement():m_head_rot():y() * 200
		local ray = managers.player:player_unit():raycast("ray", from, to, "slot_mask", managers.slot:get_mask("trip_mine_placeables"), "ignore_unit", {})
		
		if ray then
			local pos = ray.position
			local rot = managers.player:player_unit():movement():m_head_rot()
			local rot = Rotation( rot:yaw(), 0, 0 )
			local selected_index = nil
			if Network:is_client() then
				managers.network:session():send_to_host( "place_sentry_gun", pos, rot, ammo_multiplier, armor_multiplier, damage_multiplier, selected_index, unit )
				PlayerEquipment.sentrygun_placement_requested = true
			else
				local shield = managers.player:has_category_upgrade( "sentry_gun", "shield" )
				local sentry_gun_unit = SentryGunBase.spawn( unit, pos, rot, ammo_multiplier, armor_multiplier, damage_multiplier )
				if sentry_gun_unit then
				managers.network:session():send_to_peers_synched( "from_server_sentry_gun_place_result", managers.network:session():local_peer():id(), selected_index, sentry_gun_unit, sentry_gun_unit:movement()._rot_speed_mul, sentry_gun_unit:weapon()._setup.spread_mul, shield )
				else
				end
			end
		end
	end
	-- SPAWN ECM ON SELF
	spjammer = spjammers or function()
		local from = managers.player:player_unit():movement():m_head_pos()
		local to = from + managers.player:player_unit():movement():m_head_rot():y() * 200
		local ray = managers.player:player_unit():raycast("ray", from, to, "slot_mask", managers.slot:get_mask("trip_mine_placeables"), "ignore_unit", {})
		
		if ray then
		local pos = ray.position
		local unit2 = managers.player:player_unit()
		local duration_multiplier = managers.player:upgrade_value( "ecm_jammer", "duration_multiplier", 1 ) * managers.player:upgrade_value( "ecm_jammer", "duration_multiplier_2", 1 )
			if Network:is_client() then
				managers.network:session():send_to_host( "request_place_ecm_jammer", pos, ray.normal, duration_multiplier )
				PlayerEquipment.ecm_jammer_placement_requested = true
			else
				local rot = Rotation(ray.normal, math.UP)
				local unit = ECMJammerBase.spawn( pos, rot, duration_multiplier, unit2 )
				unit:base():set_active( true )
			end
		end
	end
	-- SPAWN AMMOBAG ON SELF
	spammobag = spammobags or function()
		local pos = managers.player:player_unit():position()
		local rot = managers.player:player_unit():rotation()
		local ammo_upgrade_lvl = managers.player:upgrade_level( "ammo_bag", "ammo_increase" )
			if Network:is_client() then
				managers.network:session():send_to_host( "place_deployable_bag", "AmmoBagBase", pos, rot, ammo_upgrade_lvl )
			else 
				local unit = AmmoBagBase.spawn( pos, rot, ammo_upgrade_lvl )
			end
	end
	-- SPAWN GRENADE CRATE/SUITCASE ON SELF --- OBS HOST ONLY ---
	nadebag = nadebag or function()
		if isHost() then
			GrenadeCrateBase.spawn(managers.player:player_unit():position(), managers.player:player_unit():rotation())
		end
	end
	--DAMAGE MULTIPLIER
	damagex2 = damagex2 or function()
		function CopDamage:damage_bullet( attack_data )
			attack_data.damage = attack_data.damage * 2
		return self:damage_bullet2( attack_data )
		end
	end
	damagex10 = damagex10 or function()
		function CopDamage:damage_bullet( attack_data )
			attack_data.damage = attack_data.damage * 10
		return self:damage_bullet2( attack_data )
		end
	end
	damagex10000 = damagex10000 or function()
			function CopDamage:damage_bullet( attack_data )
			attack_data.damage = attack_data.damage * 10000
		return self:damage_bullet2( attack_data )
		end
	end
	if not _original then _original = PlayerManager.upgrade_value end 
	noobaim = noobaim or function()
		function PlayerManager:upgrade_value( category, upgrade, default )
			managers.hud:on_crit_confirmed()
			return _original(self, category, upgrade, default)
		end
	end
	
	bombastic = bombastic or function()
		dofiles("trainer/assets/bombastic.lua")
	end
	
	-- WEAPON PRESETS
	extremeset = function()
		infammo()
		infsawammo()
		recoiloff()
		spreadoff()
		freload2()
		firerate2()
		swapspeed2()
		piercing()
		godsentry()
		infsentry()
		damagex10000()
		noobaim()
		passivechicks()
		weaproll()
		infnadecase()
		bombastic()
		show_mid_text("Spend ammo like there's no tomorrow", "EXTREME OVERKILL SETTINGS", 3 )
	end
	favoriteset = function()
		recoiloff()
		spreadoff()
		freload()
		firerate1()
		swapspeed()
		damagex2()
		passivechicks()
		weaproll()
		infnadecase()
		bombastic()
		show_mid_text("Now give 'em hell", "FAVORITE WEAPON SETTINGS", 3 )
	end
	--[[ ADD WEAPON WITH MOD AND BLUEPRINT SUPPORT
	(weapon) WEAPON WITH STANDARD BLUEPRINT 
	(weapon,nil,nil) = BAREBONE WEAPON
	( "weapon_name", { "mod1_name", "mod2_name" }, { "blueprint_item1", "blueprint_item2" } ) - OMIT BLUEPRINT ITEMS TO REMOVE 
	GOOD STUFF IS IN WEAPONSTWEAKDATA.LUA
	]]--
	add_weapon_with_mods = add_weapon_with_mods or function(weapon, mods, bluevoid)
		local blueprint = nil
		if mods then
			blueprint = bluevoid or deep_clone(tweak_data.weapon.factory[weapon].default_blueprint)
			for _,v in pairs(mods) do
				table.insert(blueprint,v)
			end
		end
		managers.player:player_unit():inventory():add_unit_by_factory_name( weapon, true, true, blueprint)
	end
	-- ADD WEAPON FUNCTIONS
	addweapon1 = function()
		add_weapon_with_mods("wpn_fps_saw")
		PlayMedia("trainer/media/effects/sawidle.mp3")
	end
	addweapon2 = function()
		add_weapon_with_mods("wpn_fps_ass_m4", { "wpn_fps_m4_upper_reciever_edge", "wpn_fps_m4_uupg_b_long", "wpn_fps_m4_uupg_fg_lr300", "wpn_fps_upg_m4_m_pmag", "wpn_fps_upg_m4_s_pts", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_m4_lower_reciever", "wpn_fps_m4_uupg_draghandle" })
		PlayMedia("trainer/media/effects/riflecock1.mp3")
	end
	addweapon3 = function()
		add_weapon_with_mods("wpn_fps_pis_g18c", { "wpn_fps_pis_g18c_co_1", "wpn_fps_pis_g18c_m_mag_33rnd", "wpn_fps_pis_g18c_s_stock", "wpn_fps_upg_fl_pis_laser", "wpn_fps_upg_ns_pis_large", "wpn_fps_pis_g18c_g_ergo" }, { "wpn_fps_pis_g18c_body_frame", "wpn_fps_pis_g18c_b_standard" }) -- "wpn_fps_pis_g18c_co_comp_2",
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon4 = function()
		add_weapon_with_mods("wpn_fps_ass_amcar", { "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_m4_upper_reciever_round_vanilla", "wpn_fps_upg_o_docter", "wpn_fps_upg_fl_ass_smg_sho_surefire", "wpn_fps_m4_uupg_m_std" }, { "wpn_fps_m4_uupg_b_medium_vanilla", "wpn_fps_m4_lower_reciever", "wpn_fps_amcar_uupg_fg_amcar", "wpn_fps_upg_m4_s_standard_vanilla", "wpn_fps_upg_m4_g_standard_vanilla" })
		PlayMedia("trainer/media/effects/shellfall.mp3")
	end
	addweapon5 = function()
		add_weapon_with_mods("wpn_fps_ass_m16", { "wpn_fps_m16_fg_vietnam", "wpn_fps_m4_lower_reciever", "wpn_fps_m4_upper_reciever_edge", "wpn_fps_upg_m4_m_pmag", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_o_docter", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_m4_uupg_b_medium_vanilla", "wpn_fps_m4_lower_reciever", "wpn_fps_m4_uupg_draghandle", "wpn_fps_m16_s_solid_vanilla" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon6 = function()
		add_weapon_with_mods("wpn_fps_smg_olympic", { "wpn_fps_m4_upper_reciever_edge",	"wpn_fps_smg_olympic_fg_railed", "wpn_fps_upg_m4_s_pts", "wpn_fps_m4_uupg_b_medium", "wpn_fps_upg_m4_m_drum", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg",	"wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_fl_ass_smg_sho_surefire", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_m4_uupg_draghandle", "wpn_fps_upg_m4_m_straight_vanilla", "wpn_fps_m4_lower_reciever" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon7 = function()
		add_weapon_with_mods("wpn_fps_ass_74",{ "wpn_fps_ass_akm_body_upperreceiver", "wpn_upg_ak_m_drum", "wpn_upg_ak_fg_combo2", "wpn_upg_ak_g_standard", "wpn_upg_ak_s_psl", "wpn_fps_upg_o_aimpoint_2", "wpn_fps_upg_vg_ass_smg_verticalgrip", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_tank" }, { "wpn_fps_ass_74_b_standard", "wpn_fps_ass_ak_body_lowerreceiver" })
		PlayMedia("trainer/media/effects/akrape.mp3")
	end
	addweapon8 = function()
		add_weapon_with_mods("wpn_fps_ass_akm", { "wpn_upg_ak_fg_combo3", "wpn_upg_ak_s_psl", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_tank" }, { "wpn_upg_ak_m_akm", "wpn_upg_ak_g_standard", "wpn_fps_ass_akm_b_standard", "wpn_fps_ass_akm_body_upperreceiver_vanilla", "wpn_fps_ass_ak_body_lowerreceiver" })
		PlayMedia("trainer/media/effects/akrape.mp3")
	end
	addweapon9 = function()
		add_weapon_with_mods("wpn_fps_smg_akmsu", { "wpn_fps_smg_akmsu_fg_rail", "wpn_upg_ak_g_standard", "wpn_upg_ak_s_psl", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_smg_akmsu_body_lowerreceiver", "wpn_fps_ass_akm_body_upperreceiver_vanilla", "wpn_fps_smg_akmsu_b_standard", "wpn_upg_ak_g_standard", "wpn_upg_ak_m_akm" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon10 = function()
		add_weapon_with_mods("wpn_fps_shot_saiga", { "wpn_upg_saiga_fg_lowerrail", "wpn_upg_saiga_m_20rnd", "wpn_fps_upg_o_docter", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_upg_ak_s_skfoldable", "wpn_fps_upg_ns_shot_shark" }, { "wpn_fps_smg_akmsu_body_lowerreceiver", "wpn_fps_ass_akm_body_upperreceiver_vanilla", "wpn_fps_shot_saiga_b_standard", "wpn_upg_ak_g_standard" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon11 = function()
		add_weapon_with_mods("wpn_fps_ass_ak5", { "wpn_fps_ass_ak5_body_rail", "wpn_fps_ass_ak5_fg_fnc", "wpn_fps_ass_ak5_s_ak5c", "wpn_fps_upg_m4_m_pmag", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_ass_ak5_b_std", "wpn_fps_ass_ak5_body_ak5" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon12 = function()
		add_weapon_with_mods("wpn_fps_ass_aug", { "wpn_fps_aug_fg_a3", "wpn_fps_aug_ris_special", "wpn_fps_aug_b_short", "wpn_fps_aug_m_pmag", "wpn_upg_o_marksmansight_rear_vanilla", "wpn_upg_o_marksmansight_front_vanilla", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_aug_body_aug" })
		PlayMedia("trainer/media/effects/riflecock2.mp3")
	end
	addweapon13 = function()
		add_weapon_with_mods("wpn_fps_ass_g36", { "wpn_fps_ass_g36_body_sl8", "wpn_fps_ass_g36_m_standard", "wpn_fps_ass_g36_fg_ksk", "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_ass_g36_body_standard", "wpn_fps_ass_g36_g_standard", "wpn_fps_ass_g36_b_long", "wpn_fps_ass_g36_fg_k", "wpn_fps_ass_g36_s_standard" })
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon14 = function() 
		add_weapon_with_mods("wpn_fps_smg_p90", { "wpn_fps_smg_p90_b_long", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_smg_p90_body_p90", "wpn_fps_smg_p90_m_std" }) --"wpn_fps_upg_o_specter", "wpn_fps_upg_o_aimpoint", "wpn_fps_upg_o_docter", "wpn_fps_upg_o_eotech", "wpn_fps_upg_o_t1micro", "wpn_fps_upg_o_aimpoint_2", "wpn_upg_o_marksmansight_rear_vanilla", "wpn_upg_o_marksmansight_front", "wpn_fps_upg_fl_ass_smg_sho_surefire" 
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon15 = function()
		add_weapon_with_mods("wpn_fps_ass_m14", { "wpn_fps_ass_m14_b_standard", "wpn_fps_ass_m14_body_jae", "wpn_fps_upg_o_docter", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_ass_m14_b_standard", "wpn_fps_ass_m14_body_dmr", "wpn_fps_ass_m14_m_standard", "wpn_fps_ass_m14_body_lower", "wpn_fps_ass_m14_body_upper" })
		PlayMedia("trainer/media/effects/riflecock3.mp3")
	end
	addweapon16 = function()
		add_weapon_with_mods("wpn_fps_smg_mp9", { "wpn_fps_smg_mp9_m_extended", "wpn_fps_smg_mp9_s_skel", "wpn_fps_upg_vg_ass_smg_verticalgrip", "wpn_fps_upg_o_docter", "wpn_fps_upg_ns_ass_smg_firepig","wpn_fps_upg_fl_ass_smg_sho_peqbox" }, {"wpn_fps_smg_mp9_body_mp9", "wpn_fps_smg_mp9_b_dummy" }) 
		PlayMedia("trainer/media/effects/riflecock2.mp3")
	end
	addweapon17 = function()
		add_weapon_with_mods("wpn_fps_pis_deagle",{ "wpn_fps_pis_deagle_b_long", "wpn_fps_pis_deagle_co_long", "wpn_fps_pis_deagle_fg_rail", "wpn_fps_pis_deagle_g_bling", "wpn_fps_pis_deagle_m_extended", "wpn_upg_o_marksmansight_rear", "wpn_fps_pis_deagle_o_standard_front_long", "wpn_fps_upg_fl_pis_laser" }, { "wpn_fps_pis_deagle_body_standard" }) --"wpn_fps_pis_deagle_o_standard_front", "wpn_fps_pis_deagle_o_standard_front_long", "wpn_upg_o_marksmansight_rear", "wpn_fps_pis_deagle_o_standard_rear"
		PlayMedia("trainer/media/effects/guncockslow.mp3")
	end
	addweapon18 = function()
		add_weapon_with_mods("wpn_fps_smg_mp5", { "wpn_fps_smg_mp5_fg_m5k", "wpn_fps_smg_mp5_m_drum", "wpn_fps_smg_mp5_s_ring", "wpn_fps_upg_o_docter", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_vg_ass_smg_afg" }, { "wpn_fps_smg_mp5_body_mp5", "wpn_fps_smg_mp5_s_solid" }) -- "wpn_fps_smg_mp5_s_ring", "wpn_fps_smg_mp5_s_adjust", "wpn_fps_smg_mp5_s_solid", "wpn_fps_smg_mp5_fg_m5k", "wpn_fps_smg_mp5_fg_mp5a5", "wpn_fps_smg_mp5_fg_mp5sd"
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon19 = function()
		add_weapon_with_mods("wpn_fps_pis_1911", { "wpn_fps_pis_1911_co_2", "wpn_fps_pis_1911_g_bling", "wpn_fps_pis_1911_b_vented", "wpn_fps_pis_1911_m_extended", "wpn_upg_o_marksmansight_rear", "wpn_fps_upg_fl_pis_laser" }, { "wpn_fps_pis_1911_body_standard" })
		PlayMedia("trainer/media/effects/shellfall.mp3")
	end
	addweapon20 = function()
		add_weapon_with_mods("wpn_fps_smg_mac10", { "wpn_fps_smg_mac10_body_ris", "wpn_fps_smg_mac10_m_extended", "wpn_fps_smg_mac10_body_mac10", "wpn_fps_smg_mac10_body_ris", "wpn_fps_upg_o_docter", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_vg_ass_smg_afg" }, { "wpn_fps_smg_mac10_body_mac10", "wpn_fps_smg_mac10_b_dummy" })-- "wpn_fps_smg_mac10_s_skel" = skeleton stock
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon21 = function()
		add_weapon_with_mods("wpn_fps_shot_serbu", { "wpn_fps_shot_r870_body_rack", "wpn_fps_shot_r870_fg_railed", "wpn_fps_shot_shorty_m_extended_short", "wpn_fps_upg_o_docter", "wpn_fps_shot_r870_s_folding", "wpn_fps_upg_m4_s_pts", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_ns_shot_thick", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_shot_r870_body_standard", "wpn_fps_shot_r870_b_short" })
		PlayMedia("trainer/media/effects/cockpump.mp3")
	end
	addweapon22 = function()
		add_weapon_with_mods("wpn_fps_shot_r870", { "wpn_fps_shot_r870_body_rack", "wpn_fps_shot_r870_fg_railed", "wpn_fps_shot_r870_m_extended", "wpn_fps_upg_m4_s_pts", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_ns_shot_shark", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_shot_r870_body_standard", "wpn_fps_shot_r870_b_long" })
		PlayMedia("trainer/media/effects/cockpump.mp3")
	end
	addweapon23 = function()
		add_weapon_with_mods("wpn_fps_pis_g17", { "wpn_fps_upg_ns_pis_large" }, { "wpn_fps_pis_g17_body_standard", "wpn_fps_pis_g17_b_standard", "wpn_fps_pis_g17_m_standard" })
		PlayMedia("trainer/media/effects/guncockslow.mp3")
	end
	addweapon24 = function()
		add_weapon_with_mods("wpn_fps_pis_beretta", { "wpn_fps_upg_fl_pis_laser", "wpn_fps_pis_beretta_body_rail","wpn_fps_pis_beretta_g_ergo","wpn_fps_pis_beretta_m_extended","wpn_fps_pis_beretta_sl_brigadier"}, { "wpn_fps_pis_beretta_body_beretta", "wpn_fps_pis_beretta_b_std"})
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	addweapon25 = function()
		add_weapon_with_mods("wpn_fps_shot_huntsman")
		PlayMedia("trainer/media/effects/2shotcock.mp3")
	end
	addweapon26 = function()
		add_weapon_with_mods("wpn_fps_pis_rage", { "wpn_fps_pis_rage_body_smooth", "wpn_fps_pis_rage_b_comp1", "wpn_fps_pis_rage_b_comp2", "wpn_fps_pis_rage_g_ergo" }, {})
		PlayMedia("trainer/media/effects/makeday.mp3")
	end
	-- COMMUNITY ITEM WEAPON / HELLOWEEN
	addweapon27 = function()
		add_weapon_with_mods("wpn_fps_pis_usp")
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	-- CUSTOM WEAPONS
	deatheagle = function()
		table.insert(tweak_data.weapon.factory.wpn_fps_pis_deagle.uses_parts, "wpn_fps_upg_m4_m_drum") --"wpn_fps_upg_m4_m_drum") "wpn_fps_pis_deagle_m_extended"
		add_weapon_with_mods("wpn_fps_pis_deagle",{ "wpn_fps_pis_deagle_b_long", "wpn_fps_pis_deagle_co_long", "wpn_fps_pis_deagle_fg_rail", "wpn_fps_pis_deagle_g_bling", "wpn_fps_upg_m4_m_drum", "wpn_upg_o_marksmansight_rear", "wpn_fps_pis_deagle_o_standard_front_long", "wpn_fps_upg_fl_pis_laser" }, { "wpn_fps_pis_deagle_body_standard" }) --"wpn_fps_pis_deagle_o_standard_front", "wpn_fps_pis_deagle_o_standard_front_long", "wpn_upg_o_marksmansight_rear", "wpn_fps_pis_deagle_o_standard_rear"
		recoiloff()
		spreadoff()
		freload()
		damagex10000()
		PlayMedia("trainer/media/effects/guncockslow.mp3")
	end
	simpass = function()
		add_weapon_with_mods("wpn_fps_ass_m14" , { "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_o_docter" })
		recoiloff()
		spreadoff()
		freload()
		piercing()
		PlayMedia("trainer/media/effects/riflecock3.mp3")
	end
	pcapass = function()
		add_weapon_with_mods("wpn_fps_ass_m16", { "wpn_fps_upg_o_eotech", "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_m4_m_pmag", "wpn_fps_m16_fg_vietnam" , "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_m4_uupg_b_long", "wpn_fps_m4_upper_reciever_edge" }, { "wpn_fps_m4_lower_reciever", "wpn_fps_m4_upper_reciever_round", "wpn_fps_m4_uupg_draghandle", "wpn_fps_m16_s_solid_vanilla" } )
		recoiloff()
		spreadoff()
		freload()
		piercing()
		infammo()
		damagex2()
		PlayMedia("trainer/media/effects/gunagetgun.mp3")
	end
	oliass = function()
		add_weapon_with_mods("wpn_fps_ass_m4", { "wpn_fps_m4_upper_reciever_edge", "wpn_fps_m4_uupg_b_sd", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_m4_uupg_fg_lr300", "wpn_fps_upg_m4_m_drum", "wpn_fps_m4_uupg_s_fold", "wpn_fps_upg_m4_s_pts", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_m4_g_sniper", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_m4_uupg_draghandle"	} )
		recoiloff()
		spreadoff()
		freload()
		PlayMedia("trainer/media/effects/riflecock2.mp3")
	end
	mp2013 = function()
		add_weapon_with_mods("wpn_fps_smg_p90", { "wpn_fps_upg_fl_ass_smg_sho_surefire", "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_o_docter", "wpn_fps_smg_p90_b_long" })
		recoiloff()
		spreadoff()
		freload()
		PlayMedia("trainer/media/effects/riflecock1.mp3")
	end
	stryk9 = function()
		add_weapon_with_mods( "wpn_fps_pis_g18c" , { "wpn_fps_pis_g18c_co_comp_2", "wpn_fps_pis_g18c_m_mag_33rnd", "wpn_fps_pis_g18c_s_stock", "wpn_fps_upg_fl_pis_laser", "wpn_fps_upg_ns_pis_small", "wpn_fps_pis_g18c_g_ergo" }, { "wpn_fps_pis_g18c_body_frame", "wpn_fps_pis_g18c_b_standard" })
		recoiloff()
		spreadoff()
		freload()
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	solid16 = function()
		add_weapon_with_mods("wpn_fps_ass_m16", { "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_m4_m_drum", "wpn_fps_upg_o_docter" }, { "wpn_fps_m4_uupg_b_medium_vanilla", "wpn_fps_m4_lower_reciever", "wpn_fps_m4_upper_reciever_round", "wpn_fps_m4_uupg_draghandle", "wpn_fps_m16_fg_standard", "wpn_fps_m16_s_solid_vanilla", "wpn_fps_upg_m4_m_straight_vanilla", "wpn_fps_upg_m4_g_standard_vanilla" } )
		recoiloff()
		spreadoff()
		freload()
		piercing()
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	evilizma = function()
		table.insert(tweak_data.weapon.factory.wpn_fps_shot_saiga.uses_parts, "wpn_fps_upg_m4_m_drum")
		add_weapon_with_mods("wpn_fps_shot_saiga", { "wpn_fps_upg_m4_m_drum", "wpn_upg_saiga_fg_lowerrail", "wpn_fps_shot_saiga_m_5rnd", "wpn_upg_saiga_m_20rnd", "wpn_upg_ak_g_standard",  "wpn_fps_upg_o_docter",	"wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_upg_ak_s_skfoldable", "wpn_fps_upg_ns_shot_shark" }, { "wpn_fps_smg_akmsu_body_lowerreceiver", "wpn_fps_ass_akm_body_upperreceiver_vanilla", "wpn_fps_shot_saiga_b_standard", "wpn_fps_shot_saiga_m_5rnd", "wpn_upg_ak_g_standard" })
		recoiloff()
		spreadoff()
		damagex2()
			PlayMedia("trainer/media/effects/riflecock1.mp3")
	end
	moviesaw = function()
		add_weapon_with_mods("wpn_fps_saw")
		infsawammo()
		PlayMedia("trainer/media/effects/sawidle.mp3")
	end
	s555lmg = function()
		table.insert(tweak_data.weapon.factory.wpn_fps_ass_s552.uses_parts, "wpn_fps_upg_m4_m_drum")
		add_weapon_with_mods("wpn_fps_ass_s552", { "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_m4_m_drum" }, { "wpn_fps_ass_s552_b_long", "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_ass_s552_g_standard_green", "wpn_fps_ass_s552_o_flipup", "wpn_fps_ass_s552_s_m4", "wpn_fps_ass_s552_body_standard_black",  } )
		recoiloff()
		spreadoff()
		piercing()
		damagex2()
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	ak2020 = ak2020 or function()
	add_weapon_with_mods("wpn_fps_ass_ak5", { "wpn_fps_ass_ak5_body_rail", "wpn_fps_ass_ak5_fg_fnc", "wpn_fps_ass_ak5_s_ak5c", "wpn_fps_upg_m4_m_pmag", "wpn_fps_upg_o_docter", "wpn_fps_upg_vg_ass_smg_afg", "wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_firepig" }, { "wpn_fps_ass_ak5_b_std", "wpn_fps_ass_ak5_body_ak5" })
		recoiloff()
		spreadoff()
		piercing()
		damagex2()
		freload2()
		damagex10()
		PlayMedia("trainer/media/effects/1clipin.mp3")
	end
	-- BAD ASS EAGLE RIFLE (BLACKWING REQUEST)
	beagle = function()
		table.insert(tweak_data.weapon.factory.wpn_fps_ass_scar.uses_parts, "wpn_fps_upg_m4_m_drum")
		add_weapon_with_mods("wpn_fps_ass_scar", { "wpn_fps_ass_scar_b_long", "wpn_fps_upg_o_acog", "wpn_fps_upg_m4_m_drum", "wpn_fps_upg_i_singlefire", "wpn_fps_ass_scar_o_flipups_down", "wpn_fps_ass_scar_ns_short", "wpn_fps_ass_scar_fg_railext", "wpn_fps_ass_scar_s_sniper", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_ass_scar_body_standard" })
		recoiloff()
		damagex2()
		piercing()
		PlayMedia("trainer/media/effects/beagle.mp3")
	end
	addrage = function()
		table.insert(tweak_data.weapon.factory.wpn_fps_pis_rage.uses_parts, "wpn_fps_upg_fl_ass_smg_sho_surefire")
		add_weapon_with_mods("wpn_fps_pis_rage", { "wpn_fps_pis_rage_body_smooth", "wpn_fps_upg_fl_ass_smg_sho_surefire", "wpn_fps_pis_rage_b_comp1", "wpn_fps_pis_rage_b_comp2", "wpn_fps_pis_rage_g_ergo" }, {})
		spreadoff()
		freload2()
		damagex2()
		piercing()
		PlayMedia("trainer/media/effects/makeday.mp3")
	end
	addcapslmg = function()
		add_weapon_with_mods("wpn_fps_lmg_m249", { "wpn_fps_lmg_m249_b_long", "wpn_fps_lmg_m249_fg_mk46", "wpn_fps_lmg_m249_s_solid", "wpn_fps_upg_ns_ass_smg_firepig", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_lmg_m249_body_standard", "wpn_fps_lmg_m249_m_standard", "wpn_fps_lmg_m249_upper_reciever" } )
		spreadoff()
		freload2()
		damagex2()
		piercing()
		PlayMedia("trainer/media/effects/makeday.mp3")
		dofiles("trainer/assets/passivechicks.lua")
	end
	addshenam249 = function()
      table.insert(tweak_data.weapon.factory.wpn_fps_lmg_m249.uses_parts, "wpn_fps_upg_ns_ass_smg_large")
      add_weapon_with_mods("wpn_fps_lmg_m249", { "wpn_fps_lmg_m249_b_long", "wpn_fps_lmg_m249_fg_mk46", "wpn_fps_lmg_m249_s_solid", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_lmg_m249_body_standard", "wpn_fps_lmg_m249_m_standard", "wpn_fps_lmg_m249_upper_reciever" } )
	end
	-- ARMOURED TRANSPORT DLC WEAPONS
	dlcweap1 = function()
		add_weapon_with_mods("wpn_fps_ass_s552", { "wpn_fps_upg_o_cmore", "wpn_fps_ass_s552_b_long", "wpn_fps_ass_s552_fg_standard_green", "wpn_fps_ass_s552_g_standard_green", "wpn_fps_ass_s552_s_standard_green", "wpn_fps_ass_s552_body_standard_black"},{ "wpn_fps_ass_s552_m_standard" })
	end
	dlcweap2 = function()
		add_weapon_with_mods("wpn_fps_smg_m45", { "wpn_fps_smg_m45_s_folded", "wpn_fps_smg_m45_g_bling", "wpn_fps_smg_m45_b_green", "wpn_fps_smg_m45_m_extended" },{ "wpn_fps_smg_m45_body_green" })
	end
	dlcweap3 = function()
		add_weapon_with_mods("wpn_fps_pis_ppk", { "wpn_fps_pis_ppk_g_laser", "wpn_fps_pis_ppk_b_long", "wpn_fps_pis_ppk_m_standard", "wpn_fps_pis_ppk_fl_mount" }, { "wpn_fps_pis_ppk_body_standard" })
	end
	-- GAGE WEAPON PACK DLC WEAPONS (UPDATE 19)
	dlcweap4 = function()
		add_weapon_with_mods("wpn_fps_pis_p226", { "wpn_fps_upg_fl_pis_laser", "wpn_fps_pis_p226_b_equinox", "wpn_fps_pis_p226_g_ergo", "wpn_fps_pis_p226_o_long", "wpn_fps_pis_p226_co_comp_2", "wpn_fps_pis_p226_m_extended" }, { "wpn_fps_pis_p226_body_standard" })
	end
	dlcweap5 = function()
		add_weapon_with_mods("wpn_fps_smg_mp7", { "wpn_fps_smg_mp7_m_extended", "wpn_fps_smg_mp7_b_suppressed", "wpn_fps_smg_mp7_s_long", "wpn_fps_upg_o_docter",	"wpn_fps_upg_fl_ass_smg_sho_peqbox", "wpn_fps_upg_ns_ass_smg_large", "wpn_fps_upg_i_singlefire" }, { "wpn_fps_smg_mp7_body_standard" })
	end
	dlcweap6 = function()
		add_weapon_with_mods("wpn_fps_ass_scar", { "wpn_fps_ass_scar_b_long", "wpn_fps_upg_o_docter", "wpn_fps_upg_i_singlefire", "wpn_fps_ass_scar_o_flipups_down", "wpn_fps_ass_scar_ns_short", "wpn_fps_ass_scar_fg_railext", "wpn_fps_ass_scar_s_sniper", "wpn_fps_upg_fl_ass_smg_sho_peqbox" }, { "wpn_fps_ass_scar_body_standard", "wpn_fps_ass_scar_m_standard" })
	end

	-- GAGE WEAPONS #02
	addm249 = function()
		add_weapon_with_mods("wpn_fps_lmg_m249")
		PlayMedia("trainer/media/effects/m249.mp3")
	end
	addrpk = function()
		add_weapon_with_mods("wpn_fps_lmg_rpk" )
	end
	addhk21 = function()
		add_weapon_with_mods("wpn_fps_lmg_hk21")
	end
	addakgold = function()
		add_weapon_with_mods("wpn_fps_ass_akm_gold")
	end
	addm95 = function()
		add_weapon_with_mods("wpn_fps_snp_m95")
	end
	addmsr = function()
		add_weapon_with_mods("wpn_fps_snp_msr")
	end
	addg22 = function()
		add_weapon_with_mods("wpn_fps_pis_g22c") -- dafuq is this gun???
	end
	addr93 = function()
		add_weapon_with_mods("wpn_fps_snp_r93")
	end
	
	--[[ FUTURE DLC WEAPONS
	-- dlcweap7 = function()
	-- add_weapon_with_mods("", { "", "", "" }, { "" })
	-- end
	-- dlcweap8 = function()
	-- add_weapon_with_mods("", { "", "", "" }, { "" })
	-- end
	-- dlcweap9 = function()
	-- add_weapon_with_mods("", { "", "", "" }, { "" })
	-- end
	-------------------
	-- SCOPE OPTIONS --
	-------------------
	"wpn_fps_upg_o_eotech"  
	"wpn_fps_upg_o_specter" 
	"wpn_fps_upg_o_docter" 
	"wpn_fps_upg_o_aimpoint" 
	"wpn_fps_upg_o_aimpoint_2"
	"wpn_fps_upg_o_t1micro"
	"wpn_fps_upg_o_cmore"
	"wpn_fps_m4_uupg_o_flipup"
	"wpn_fps_ass_m16_os_frontsight"
	"wpn_fps_ass_m16_o_handle_sight"
	
	-- SMG + ASSAULT
	Laser pointer
	"wpn_fps_upg_fl_ass_smg_sho_peqbox"
	Flashlight
	"wpn_fps_upg_fl_ass_smg_sho_surefire"

	-- PISTOLS
	Laser pointer
	"wpn_fps_upg_fl_pis_laser"
	Flashlight
	"wpn_fps_upg_fl_pis_tlr1"

	used to force acceptance of unfit items
	table.insert(tweak_data.weapon.factory.wpn_fps_ass_m16.uses_parts, "wpn_fps_ass_m16_os_frontsight" ) ]]--

	-- CHANGE TO OWN PRIMARIES INGAME
	userweap1 = userweap1 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[1] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap2 = userweap2 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[2] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap3 = userweap3 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[3] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap4 = userweap4 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[4] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap5 = userweap5 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[5] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap6 = userweap6 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[6] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap7 = userweap7 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[7] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap8 = userweap8 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[8] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	userweap9 = userweap9 or function()
		local weapon = Global.blackmarket_manager.crafted_items.primaries[9] --secondaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	-- CHANGE TO OWN SECONDARIES INGAME
	usersweap1 = usersweap1 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[1] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap2 = usersweap2 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[2] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap3 = usersweap3 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[3] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap4 = usersweap4 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[4] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap5 = usersweap5 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[5] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap6 = usersweap6 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[6] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap7 = usersweap7 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[7] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap8 = usersweap8 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[8] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end
	usersweap9 = usersweap9 or function()
		local weapon = Global.blackmarket_manager.crafted_items.secondaries[9] --primaries 
		if weapon then 
			managers.player:player_unit():inventory():add_unit_by_factory_name( weapon.factory_id, false, false, weapon.blueprint ) --The first false means to not equip it, the second false means it's not instant. 
		end
	end

	-- CUSTOM LASER COLOR
	function lasercolor(lcolor)
		for _,weapon in pairs(managers.player:player_unit():inventory():available_selections()) do
			if weapon.unit.base and weapon.unit:base()._parts then
				for k,v in pairs(weapon.unit:base()._parts) do
					if k:find("laser") or k:find("peqbox") or k:find("peq15") then
						v.unit:base():set_color((lcolor):with_alpha(0.8))
					end
				end
			end
		end
	end

	--CUSTOM FLASHLIGHT COLOR
	function flashcolor(fcolor)
		for _,weapon in pairs(managers.player:player_unit():inventory():available_selections()) do
			if weapon.unit.base and weapon.unit:base()._parts then
				for k,v in pairs(weapon.unit:base()._parts) do
					if k:find("surefire") then
						v.unit:base()._light:set_color((fcolor):with_alpha(0.8))
					elseif k:find("tlr1") then
						v.unit:base()._light:set_color((fcolor):with_alpha(0.8))
					end
				end
			end
		end
	end
	
	--CUSTOM FLASHLIGHT TEXTURE
	function flashtexture(ftexture)
		for _,weapon in pairs(managers.player:player_unit():inventory():available_selections()) do
			if weapon.unit.base and weapon.unit:base()._parts then
				for k,v in pairs(weapon.unit:base()._parts) do
					--local rot = v.unit:base()._light:rotation()
					-- local rot = v.unit:base()._light
					-- v.unit:base()._light:set_rotation(Rotation(rot:z() - 90, rot:x(), rot:y()))
					if k:find("surefire") then
						v.unit:base()._light:set_projection_texture("guis/textures/".. ftexture .."")
					elseif k:find("tlr1") then
						v.unit:base()._light:set_projection_texture("guis/textures/".. ftexture .."")
					end
				end
			end
		end
	end

	-- ADD GRENADE
	naderefill = naderefill or function()
		managers.player:add_grenade_amount(3)
	end
	-- INFINITE GRENADE CASE USES
	infnadecase = infnadecase or function()
		dofiles("trainer/assets/forevernades.lua")
	end
	-- CUSTOM WEAPON MOUSE SCROLL
	weaproll = weaproll or function()
		dofiles("trainer/assets/weapscroll.lua")
	end
	-- LMG MODIFIER SCRIPT
	passivechicks = passivechicks or function()
		dofiles("trainer/assets/passivechicks.lua")
	end
	-- MELEE WEAPON CHANGE
	meleefist = meleefist or function()
		dofiles("trainer/assets/meleefists.lua")
	end
	meleebrass = meleebrass or function()
		dofiles("trainer/assets/meleeknuckles.lua")	
	end
	meleerambo = meleerambo or function()
		dofiles("trainer/assets/meleerambo.lua")	
	end
	meleegerber = meleegerber or function()
		dofiles("trainer/assets/meleegerber.lua")	
	end
	meleekabar = meleekabar or function()
		dofiles("trainer/assets/meleekabar.lua")	
	end
	meleekampf = meleekampf or function()
		dofiles("trainer/assets/meleekampfmesser.lua")	
	end
	---------------
	-- MENU --
	---------------
	callweaponoutmenu = callweaponoutmenu or function()
		openmenu(weaponoutmenu)
	end
	callweaponinmenu = callweaponinmenu or function()
		openmenu(weaponinmenu)
	end
	callweaponchangemenu = callweaponchangemenu or function()
		openmenu(weaponchangemenu)
	end
	callmeleechangemenu = callmeleechangemenu or function()
		openmenu(meleechangemenu)
	end
	callweaponchangemenu2 = callweaponchangemenu2 or function()
		openmenu(weaponchangemenu2)
	end
	callweaponchangemenu3 = callweaponchangemenu3 or function()
		openmenu(weaponchangemenu3)
	end
	callweaponchangemenu4 = callweaponchangemenu4 or function()
		openmenu(weaponchangemenu4)
	end
	callweaponchangemenu5 = callweaponchangemenu5 or function()
		openmenu(weaponchangemenu5)
	end
	callweaponchangemenuz = callweaponchangemenuz or function()
		openmenu(weaponchangemenuz)
	end
	callwrootmenuo = callwrootmenuo or function()
		openmenu(wrootmenuo)
	end
	callwrootmenui = callwrootmenui or function()
		openmenu(weaponoptionsmenu)
	end
	calllasermenu = calllasermenu or function()
		openmenu(lasercolormenu)
	end
	callflashcolormenu = callflashcolormenu or function()
		openmenu(flashcolormenu)
	end
	callflashtexturemenu = callflashtexturemenu or function()
		openmenu(flashtexturemenu)
	end
	-- PRIMARY WEAPON CHANGE MENU
	weapchangeopt = weapchangeopt or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "Saw \[ENFORCER\]", callback = addweapon1 },
		{},
		{ text = "REINFELD 880 shotgun", callback = addweapon22 },
		{ text = "IZHMA 12g shotgun", callback = addweapon10 },
		{ text = "MOSCONI 12g shotgun", callback = addweapon25 },
		{},
		{ text = "AMCAR assault rifle", callback = addweapon4 },
		{ text = "AK assault rifle", callback = addweapon7 },
		{ text = "CAR-4 assault rifle", callback = addweapon2 },
		{ text = "UAR assault rifle", callback = addweapon12 },
		{ text = "JP36 assault rifle", callback = addweapon13 },
		{ text = "AK 7.62 assault rifle", callback = addweapon8 },
		{ text = "M308 assault rifle", callback = addweapon15 },
		{ text = "AK5 assault rifle", callback = addweapon11 },
		{ text = "AMR-16 assault rifle", callback = addweapon5 },
		{ text = "S552 assault rifle", callback = dlcweap1 },
		{ text = "The eagle heavy rifle", callback = dlcweap6 },
		{},
		{ text = "RPK - AK47 LMG", callback = addrpk },
		{ text = "M249 SAW LMG", callback = addm249 },
		{ text = "HK-21 LMG", callback = addhk21 },
		}
	weaponchangemenu = weaponchangemenu or SimpleMenu:new("更换主武器", "选个主武器吧~",weapchangeopt)
	-- SECONDARY WEAPON CHANGE MENU
	weapchangeopt2 = weapchangeopt2 or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "Locomotive 12g shotgun", callback = addweapon21 },
		{},
		{ text = "Mark 10 smg", callback = addweapon20 },
		{ text = "Compact-5 smg", callback = addweapon18 },
		{ text = "Para smg", callback = addweapon6 },
		{ text = "Cmp smg ", callback = addweapon16 },
		{ text = "Krinkov smg", callback = addweapon9 },
		{ text = "Kobus-90 smg", callback = addweapon14 },
		{ text = "Swedish k smg", callback = dlcweap2 },
		{ text = "The SpecOps smg", callback = dlcweap5 },
		{},
		{ text = "Chimano 88 pistol", callback = addweapon23 },
		{ text = "Crosskill pistol", callback = addweapon19 },
		{ text = "Bronco .44 pistol", callback = addweapon26 },
		{ text = "Bernetti 9 pistol", callback = addweapon24 },
		{ text = "Stryk 18c pistol", callback = addweapon3 },
		{ text = "Deagle pistol", callback = addweapon17 },
		{ text = "USP Interceptor pistol", callback = addweapon27 },
		{ text = "Gruber Kurz Pistol", callback = dlcweap3 },
		{ text = "The signature .40 pistol", callback = dlcweap4 },
		}
	weaponchangemenu2 = weaponchangemenu2 or SimpleMenu:new("更换副武器", "选个手枪吧~",weapchangeopt2)
	-- SPECIAL WEAPONS CHANGE MENU
	weapchangeopt3 = weapchangeopt3 or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "Adamantium saw \[PRIMARY\]", callback = moviesaw },
		{},
		{ text = "The Clintwood \[SECONDARY\]", callback = addrage },
		{ text = "Death Eagle widowmaker \[SECONDARY\]", callback = deatheagle },
		{ text = "Stryk9 sidearm surprise \[SECONDARY\]", callback = stryk9 },
		{},
		{ text = "KOBUS-2013 flashpoint \[SECONDARY\]", callback = mp2013 },
		{},
		{ text = "Izhmatic leadstorm \[SECONDARY\]", callback = evilizma },
		{},
		{ text = "Perfect Beagle '998\[PRIMARY\]", callback = beagle },
		{ text = "S555 LMG Edition \[PRIMARY\]", callback = s555lmg },
		{ text = "M-16 fullspec \[PRIMARY\]", callback = solid16 },
		{ text = "AK 2020 \[PRIMARY\]", callback = ak2020 },
		{ text = "M308 Simplitico \[PRIMARY\]", callback = simpass },
		{ text = "The Olifant CAR-4 \[PRIMARY\]", callback = oliass },
		{ text = "Cap'n Special M-16 \[PRIMARY\]", callback = pcapass },
		{},
		{ text = "Firstmate's army issue m249 \[PRIMARY\]", callback = addcapslmg },
		{ text = "Shenanigans silenced m249 \[PRIMARY\]", callback = addshenam249 },
		}
	weaponchangemenu3 = weaponchangemenu3 or SimpleMenu:new("更换自定义武器", "给枪加上弹鼓",weapchangeopt3)
	-- SPECIAL WEAPONS CHANGE MENU
	weapchangeoptz = weapchangeoptz or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		--{ text = "wpn_fps_pis_g22c \[PRIMARY\]", callback = addg22 }, -- COMMENTED OUT UNTIL IDENTIFIED
		{ text = "Golden AK47 \[PRIMARY\]", callback = addakgold },
		{},
		{ text = "Rattlesnake \[PRIMARY\]", callback = addmsr },
		{ text = "Thanatos \[PRIMARY\]", callback = addm95 },
		{ text = "R93 \[PRIMARY\]", callback = addr93 },
		}
	weaponchangemenuz = weaponchangemenuz or SimpleMenu:new("更换狙击枪类武器", "成为狙击手!",weapchangeoptz)
	-- WEAPON MENU INGAME
	weaponopti2 = weaponopti2 or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "手雷箱子无限手雷 \[仅限主机\]", callback = infnadecase },
		{ text = "弹药袋中弹药无限 \[仅限主机\]", callback = infammobag },
		{ text = "哨兵机枪弹药无限 \[仅限主机\]", callback = infsentry },
		{ text = "哨兵机枪枪神模式 \[仅限主机\]", callback = godsentry },
		{},
		{ text = "无后扩散", callback = passivechicks },
		{ text = "无后座力", callback = recoiloff },
		{ text = "无散弹道射", callback = spreadoff },
		{ text = "快速装填", callback = freload },
		{ text = "急速装填", callback = freload2 },
		{ text = "提升射速", callback = firerate1 },
		{ text = "变态射速", callback = firerate2 },
		{ text = "辅助准信", callback = noobaim },
		{ text = "立即获得3颗手雷", callback = naderefill },
		{ text = "快速拾取包裹", callback = swapspeed },
		{ text = "立即拾取包裹", callback = swapspeed2 },
		{ text = "恢复护甲值到100%", callback = piercing },
		{ text = "武器伤害增加 x 2", callback = damagex2 },
		{ text = "武器伤害增加 x 10", callback = damagex10 },
		{ text = "武器伤害增加 x 10000", callback = damagex10000 },
		{ text = "爆炸伤害增加", callback = bombastic },
		{ text = "Custom weapon mousescroll(这个真不知道干吗用的(-Д-))", callback = weaproll },
		}
	weaponinmenu = weaponinmenu or SimpleMenu:new("武器设定", "更加详细的武器设定",weaponopti2)
	-- USERS PRIMARY WEAPON CHANGE MENU
	weapchangeopt4 = weapchangeopt4 or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "第一排左边的", callback = userweap1 },
		{ text = "第一排中间的", callback = userweap2 },
		{ text = "第一排右边的", callback = userweap3 },
		{ text = "第二排左边的", callback = userweap4 },
		{ text = "第二排中间的", callback = userweap5 },
		{ text = "第二排右面的", callback = userweap6 },
		{ text = "第三排左面的", callback = userweap7 },
		{ text = "第三排中间的", callback = userweap8 },
		{ text = "第三排右边的", callback = userweap9 },
		}
	weaponchangemenu4 = weaponchangemenu4 or SimpleMenu:new("更换自己武器槽内的主武器", "选择自己的主武器",weapchangeopt4)
	-- USERS SECONDARY WEAPON CHANGE MENU
	weapchangeopt5 = weapchangeopt5 or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "第一排左边的", callback = usersweap1 },
		{ text = "第一排中间的", callback = usersweap2 },
		{ text = "第一排右边的", callback = usersweap3 },
		{ text = "第二排左边的", callback = usersweap4 },
		{ text = "第二排中间的", callback = usersweap5 },
		{ text = "第二排右面的", callback = usersweap6 },
		{ text = "第三排左面的", callback = usersweap7 },
		{ text = "第三排中间的", callback = usersweap8 },
		{ text = "第三排右边的", callback = usersweap9 },
		}
	weaponchangemenu5 = weaponchangemenu5 or SimpleMenu:new("更换自己武器槽内的副武器", "选择自己的副武器",weapchangeopt5)
	-- MELEE WEAPONS CHANGE MENU
	meleechangeopt = meleechangeopt or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		{ text = "拳头", callback = meleefist },
		{ text = "拳套", callback = meleebrass },
		{ text = "Kampfmesser", callback = meleekampf },
		{ text = "Rambo knife", callback = meleerambo },
		{ text = "Gerber knife", callback = meleegerber },
		{ text = "Kabar knife", callback = meleekabar },		
		}
	meleechangemenu = meleechangemenu or SimpleMenu:new("更换近战武器", "刀子?全套?随你喜欢!",meleechangeopt)
	-- LASER COLOR CHANGE MENU
	laserchangeopt = laserchangeopt or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		--{ text = "Gazer", callback = gayzer }, -- PUT IN DONOR
		{ text = "Silver", callback = lasercolor, data = Color.silver },
		{ text = "Gold", callback = lasercolor, data = Color.gold },
		{ text = "Purple", callback = lasercolor, data = Color.purple },
		{ text = "Pink", callback = lasercolor, data = Color.labia },
		{ text = "Blue", callback = lasercolor, data = Color.blue },
		{ text = "Green", callback = lasercolor, data = Color.green },
		{ text = "Red", callback = lasercolor, data = Color.red },
		}
	lasercolormenu = lasercolormenu or SimpleMenu:new("更换激光颜色", "换个颜色吧~",laserchangeopt)
	-- FLASH COLOR CHANGE MENU
	flashchangeopt = flashchangeopt or {
		{ text = "Back", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		--{ text = "Rainbow", callback = faglight }, -- PUT IN DONOR
		{ text = "Silver", callback = flashcolor, data = Color.silver },
		{ text = "Gold", callback = flashcolor, data = Color.gold },
		{ text = "Purple", callback = flashcolor, data = Color.purple },
		{ text = "Pink", callback = flashcolor, data = Color.labia },
		{ text = "Blue", callback = flashcolor, data = Color.blue },
		{ text = "Green", callback = flashcolor, data = Color.green },
		{ text = "Red", callback = flashcolor, data = Color.red },
		}
	flashcolormenu = flashcolormenu or SimpleMenu:new("更改手电筒颜色", "晃瞎狗眼!",flashchangeopt)
	-- FLASH TEXTURE CHANGE MENU
	flashtextureopt = flashtextureopt or {
		{ text = "返回", callback = callwrootmenui },
		{ text = "", is_cancel_button = true},
		--{ text = "ROTATE TEXTURE TO FIT", callback = flashtexturerot }, -- PUT IN DONOR
		{ text = "Crimenet", callback = flashtexture, data = "crimenet_map" },
		{ text = "drill_screen_background", callback = flashtexture, data = "drill_screen_background" },
		{ text = "equilibrium_entertainment", callback = flashtexture, data = "equilibrium_entertainment" },
		{ text = "icon_star", callback = flashtexture, data = "icon_star" },
		{ text = "lightstone_entertainment", callback = flashtexture, data = "lightstone_entertainment" },
		{ text = "overkill_df", callback = flashtexture, data = "overkill_df" },
		{ text = "payday_webseries", callback = flashtexture, data = "payday_webseries" },
		{ text = "physx_df", callback = flashtexture, data = "physx_df" },
		{ text = "seven_figures_logo", callback = flashtexture, data = "seven_figures_logo" },
		{ text = "soe_logo", callback = flashtexture, data = "soe_logo" },
		{ text = "stabreeze_studios", callback = flashtexture, data = "stabreeze_studios" },
		{ text = "warning_gas", callback = flashtexture, data = "warning_gas" },
		{ text = "codex_pages", callback = flashtexture, data = "codex_pages" },
		{ text = "esrb_rating", callback = flashtexture, data = "esrb_rating" },
		{ text = "505games_df", callback = flashtexture, data = "505games_df" },
		{ text = "ammo_grenade", callback = flashtexture, data = "ammo_grenade" },
		}
	flashtexturemenu = flashtexturemenu or SimpleMenu:new("更改手电筒质感", "哇呜...嗯~多么可爱",flashtextureopt)
	--WEAPON ROOT MENU
	weaponoptions = weaponoptions or {
		{ text = "放置ECM", callback = spjammer },
		{ text = "放置弹药包", callback = spammobag },
		{ text = "放置感应雷", callback = sptripmine },
		{ text = "放置哨兵机枪", callback = spsentry },
		{ text = "放置手雷箱子\[仅限主机]", callback = nadebag },
		{},
		{ text = "退出本菜单", is_cancel_button = true},
		{},
		{ text = "更换自己武器槽内的主武器", callback = callweaponchangemenu4 },
		{ text = "更换自己武器槽内的副武器", callback = callweaponchangemenu5 },
		{},
		{ text = "更换激光颜色[高几率跳出]", callback = calllasermenu },
		{ text = "更换手电筒颜色[高几率跳出]", callback = callflashcolormenu },
		{ text = "更换手电筒质感[高几率跳出]", callback = callflashtexturemenu },
		{},
		{ text = "更换近战武器", callback = callmeleechangemenu },
		{ text = "更换主武器", callback = callweaponchangemenu },
		{ text = "更换副武器", callback = callweaponchangemenu2 },
		{ text = "更换为自定义武器", callback = callweaponchangemenu3 },
		{ text = "更换为狙击枪类武器", callback = callweaponchangemenuz },
		{},
		{ text = "武器菜单", callback = callweaponinmenu },
		{ text = "开启武器设定菜单所有功能", callback = extremeset },
		{ text = "一键作弊", callback = favoriteset },
		}
	-- ROOT MENU
	if not weaponoptionsmenu then
		weaponoptionsmenu = weaponoptionsmenu or SimpleMenu:new("武器菜单", "枪...嗯~和爆炸物", weaponoptions)
	end
else
	weaponoptions = weaponoptions or {
		{ text = "退出", is_cancel_button = true},
		{},
		{ text = "增加所有武器配件 各1个", callback = giveitems, data = { ["type"] = "weapon_mods", ["times"] = nil}},
		{ text = "增加所有武器配件 各5个", callback = giveitems, data = { ["type"] = "weapon_mods", ["times"] = 5}},
		{},
		{ text = "解锁所有主武器栏位", callback =  unlockprimslots },
		{ text = "解锁所有服务器栏位", callback =  unlocksecslots },
		{ text = "解锁所有武器栏位", callback =  unlockweaponslots },
		{},
		{ text = "解锁所有武器", callback = unlockitems, data = "weapons" },
		}
	-- ROOT MENU
	if not weaponoptionsmenu then
		weaponoptionsmenu = weaponoptionsmenu or SimpleMenu:new("Weapons menu", "guns, guns....and kaboom", weaponoptions)
	end
end
weaponoptionsmenu:show()